#---------------------------------------------
# Lectura de la base de datos "FQmarino"
datos <-read.csv2("FQmarino.csv",row.names=1)

#---------------------
# Informcin de la base de datos
round(head(datos),2)

# Estructura 
str(datos)


#  
str(datos)
# Resumen 
summary(datos)

#---------------------
# LIBRERAS REQUERIDAS
library(ggplot2)
library(reshape2)
library(ggrepel)
library(vegan)
library(ade4)
library(FactoMineR)
library(factoextra)
library(devtools)
install_github("vqv/ggbiplot")   # Escoger la Opcin 1. *Instalar solo una vez.
library(ggbiplot)
library(ggsci)
library(ggforce)
library(concaveman)



# ----------------
# 1) pca con el paquete stats
pca1 <- princomp(datos,cor=TRUE)

# Ajuste del PCA mediante los autovalores
summary(pca1)

# Insumos del pca (names)
names(pca1)

round(pca1$loadings,2)   # Autovalores (loadings)
round(pca1$scores,2)     # Coordenadas de las localidades (Scores)


# Contribucin de los ejes del pca
x11()
screeplot(pca1,ylab="Varianza",main="",
          cex.lab=1.5, col="lightblue")

# Figura del biplot del PCA. 
biplot(pca1,choices = 1:2, cex=0.9)
biplot(pca1,choices = 2:3, cex=0.9)
biplot(pca1,choices = c(1,3), cex=0.9)
abline(v=0,lty=2, col=4)
abline(h=0,lty=2, col=4)


#----------------------
# 2) PCA con el paquete FactoMiner

# Insertar las variables al PCA
names(datos)
datos.PCA<-datos[, c("pH", "Cond", "Turbidez", "Temp", "Salinidad",
                     "CapaFotica", "Oxigeno")]

# PCA con escalamiento de las variables (similar a la matriz de correlacin)              
pca2<-PCA(datos.PCA , scale.unit=TRUE, ncp=5, graph = FALSE)

# Figura del PCA 
plot.PCA(pca2, axes=c(1, 2), choix="ind", habillage="none", col.ind="black", 
         col.ind.sup="blue", col.quali="magenta", 
         label=c("ind", "ind.sup", "quali"))

# Circulo de contribuciones de las variables                                                                   
plot.PCA(pca2, axes=c(1, 2), choix="var", col.var="#ff0000", new.plot=T,
         col.quanti.sup="blue", label=c("var", "quanti.sup"), lim.cos2.var=0)


# Seleccin de variables a partir del PCA
dimdesc=dimdesc(pca2, axes=1:2)
round(dimdesc$Dim.1$quanti,4)


#--------------
# 3) PCA con el paquete vegan
pca3 <- rda(datos[,c(1:7)], scale = TRUE) 


# Insumos del anlisis
summary(pca3)

# Autovalores
round((ev <- pca3$CA$eig),2)

# Figura del PCA
x11(12,6)
par(mfrow=c(1,2))
biplot(pca3, scaling=1, main="PCA - scaling 1")
biplot(pca3, main="PCA - scaling 2")  


# Ajuste de los componentes principales
round((av <- pca3$CA$eig),2)
round(av[av > mean(av)],2)

n <- length(av)
vq <- data.frame(j=seq(1:n), p=0)
vq$p[1] <- 1/n
for (i in 2:n) {
  vq$p[i] = vq$p[i-1] + (1/(n + 1 - i))
}
vq$p <- 100*vq$p/n
vq


# Figura de atovalores
windows(title="Autovalores del PCA")
par(mfrow=c(2,1))

# a. Figura del modelo de Kaiser
barplot(av, main="Valores Propios", col="bisque", las=2)
abline(h=mean(av), col="red")	
legend("topright", "Promedio de autovalores", lwd=1, col=2, bty="n")

# b. Figura del modelo de Vara Quebrada
barplot(t(cbind(100*av/sum(av),vq$p[n:1])), beside=TRUE, main="% Varianza", col=c("bisque",2), las=2)
legend("topright", c("% Autovalores", "Modelo Vara Quebrada"), pch=15, col=c("bisque",2), bty="n")



#---------------------
# Combinacin de clasificacin y ordenacin

datos.w <- hclust(dist(scale(datos[,c(1:7)])), "ward.D")

# Cortar la clasificacin en 2 grupos
gr <- cutree(datos.w, k = 2)
grl <- levels(factor(gr))

# Extraer los escores de los sitios
sit.sc1 <- scores(pca3, display = "wa", scaling = 1)

# Graficar los sitios, con simbolos y colores 
x11()
p <- plot(pca3,  display = "wa",  scaling = 1,  type = "n",
          main = "PCA correlation + clusters")
abline(v = 0, lty = "dotted")
abline(h = 0, lty = "dotted")

for (i in 1:length(grl)) {
  points(sit.sc1[gr == i, ],
         pch = (14 + i),
         cex = 2,
         col = i + 1)
}

# Agregar nmeros de los sitios
text(sit.sc1, row.names(datos), cex = 0.7, pos = 3)

# Adicionar el dendograma
ordicluster(p, datos.w, col = "dark grey")

# Adicionar la leyenda de la figura
legend(locator(1),
       paste("Grupo", c(1:length(grl))),
       pch = 14 + c(1:length(grl)),
       col = 1 + c(1:length(grl)),
       pt.cex = 2)



#---------------------
# PCA con factor generado en el cluster anterior

# Cluster con ward
datos.w <- hclust(dist(scale(datos)), "ward.D")

# Generar 4 grupos (factor gr)
gr <- cutree(datos.w, k = 2)

# Base de datos con el factor agrupador
datos.gr=data.frame(gr,datos)
datos.gr$gr=as.factor(datos.gr$gr)  # crear los grupos como factor
datos.gr
write.csv2(datos.gr,"env.gr.csv")
str(datos.gr)

#---------------------
# 4) PCA por tipos con la funcin "dudi.pca" del paquete ade4

pca4<-dudi.pca(datos[,c(1:7)],scannf=F,nf=2,scale=T)

# figuras por tipo de dieta
names(datos)
x11()
s.class(pca4$li,datos.gr$gr,cpoint=1)
s.class(pca4$li,datos.gr$gr, cpoi = 2)
s.class(pca4$li,datos.gr$gr, cell = 0, cstar = 0.5)
coul <- c("red",  "blue")
s.chull(pca4$li,datos.gr$gr, cpoi = 1, col = coul)